function FullSave(handles)

global tracer

if isempty(tracer)
    tracer=1;
else
    clearvars all
    return
end
%% Load Files
WaitTics        = 7;
WaitSave        = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);

SavePath     = get(handles.SavePath,'String');
FileName     = get(handles.FileName,'String');
ShowOrg      = load(fullfile(tempdir,'ShowOrg.mat')).image;
Original     = load(fullfile(tempdir,'Original.mat')).image;
WaitSave.Send;
SubtrZLP     = load(fullfile(tempdir,'SubtrZLP.mat')).Data;
WaitSave.Send;
ShowDen      = load(fullfile(tempdir,'ShowDen.mat')).DenImg;
WaitSave.Send;
ShowDeconv   = load(fullfile(tempdir,'ShowDeconv.mat')).DeconvImg;
WaitSave.Send;
ShowDecSub   = load(fullfile(tempdir,'ShowDecSub.mat')).DeconvImg;

ZLP1         = load(fullfile(tempdir,'ZLP1.mat')).ZLP;
ZLP2         = load(fullfile(tempdir,'ZLP2.mat')).ZLP;
ZLP1_old     = load(fullfile(tempdir,'ZLP1.mat')).ZLP_old;
ZLP2_old     = load(fullfile(tempdir,'ZLP2.mat')).ZLP_old;
ZLP1Energies = load(fullfile(tempdir,'ZLP1.mat')).ZLPEnergies;
ZLP2Energies = load(fullfile(tempdir,'ZLP2.mat')).ZLPEnergies;
ZLP1FWHM     = load(fullfile(tempdir,'ZLP1.mat')).ZLPFWHM;
ZLP2FWHM     = load(fullfile(tempdir,'ZLP2.mat')).ZLPFWHM;
ZLP1PreZLP   = load(fullfile(tempdir,'ZLP1.mat')).PreZLP;
ZLP2PreZLP   = load(fullfile(tempdir,'ZLP2.mat')).PreZLP;
ZLP1Drift    = load(fullfile(tempdir,'ZLP1.mat')).ZLPDrift;
ZLP2Drift    = load(fullfile(tempdir,'ZLP2.mat')).ZLPDrift;
ZLP1Exp      = load(fullfile(tempdir,'ZLP1.mat')).ZLPExp;
ZLP2Exp      = load(fullfile(tempdir,'ZLP2.mat')).ZLPExp;
ZLP1Cut      = load(fullfile(tempdir,'ZLP1.mat')).ZLPCut;
ZLP2Cut      = load(fullfile(tempdir,'ZLP2.mat')).ZLPCut;
ZLP1Fine     = load(fullfile(tempdir,'ZLP1.mat')).Fine;
ZLP2Fine     = load(fullfile(tempdir,'ZLP2.mat')).Fine;
Add          = load(fullfile(tempdir,'Add.mat')).Add;
DecAdd       = load(fullfile(tempdir,'DecAdd.mat')).DecAdd;
DenLog       = load(fullfile(tempdir,'DenLog.mat')).DenLog ;
DenIntLog    = load(fullfile(tempdir,'DenIntLog.mat')).DenIntLog ;
DeconvLog    = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog ;
DecSubLog    = load(fullfile(tempdir,'DecSubLog.mat')).DecSubLog ;
SubtrZLPLog  = load(fullfile(tempdir,'SubtrZLPLog.mat')).SubtrZLPLog ;
ZLP1Log      = load(fullfile(tempdir,'ZLP1Log.mat')).ZLPLog ;
ZLP2Log      = load(fullfile(tempdir,'ZLP2Log.mat')).ZLPLog;
AlignZLP1Log = load(fullfile(tempdir,'AlignZLP1Log.mat')).AlignZLPLog;
AlignZLP2Log = load(fullfile(tempdir,'AlignZLP2Log.mat')).AlignZLPLog;

%% Get Handles

ZLPs               = get(handles.LoadPeak,'UserData');
ShowFWHM           = get(handles.ShowFWHM,'UserData');
ShowInt            = get(handles.ShowInt,'UserData');
ShowDrift          = get(handles.ShowDrift,'UserData');
ZLPAlign           = get(handles.ZLPAlign,'UserData');
Load               = get(handles.Load,'UserData');
SliderMax          = get(handles.Slider,'Max');
SliderMin          = get(handles.Slider,'Min');
SliderMaxMin       = get(handles.Slider, 'UserData');
SliderSteps        = get(handles.Slider, 'SliderStep');
SliderPos          = get(handles.Slider, 'Value');
CAxisMaxMax        = get(handles.CAxisMax,'Max');
CAxisMaxMin        = get(handles.CAxisMax,'Min');
CAxisMaxSliderStep = get(handles.CAxisMax, 'SliderStep');
CAxisMaxPos        = get(handles.CAxisMax, 'Value');
CAxisMinMax        = get(handles.CAxisMin, 'Max');
CAxisMinMin        = get(handles.CAxisMin, 'Min');
CAxisMinSliderStep = get(handles.CAxisMin, 'SliderStep');
CAxisMinPos        = get(handles.CAxisMin, 'Value');
MaxEnergy          = get(handles.MaxEnergy ,'String');
MinEnergy          = get(handles.MinEnergy,'String');
DispRange          = get(handles.DispRange,'String');
Zoom               = get(handles.Zoom,'UserData');
Back               = get(handles.Background,'UserData');
Spec               = get(handles.Spec,'UserData');
SingleSpec         = get(handles.SingleSpec,'UserData');
LoadPath           = get(handles.LoadPath,'String');
CorrGainRefString  = get(handles.CorrGainRef,'String');

IntFac1            = get(handles.IntFac1,'String');
DecFac1            = get(handles.DecFac1,'String');
SubDecFac1         = get(handles.SubDecFac1,'String');
IntFac2            = get(handles.IntFac2,'String');
DecFac2            = get(handles.DecFac2,'String');
SubDecFac2         = get(handles.SubDecFac2,'String');
IntIter            = get(handles.IntIter,'String');
DenInt             = get(handles.DenInt,'String');
DecSubIter         = get(handles.DecSubIter,'String');
DecIter            = get(handles.DecIter,'String');
StrPSF             = get(handles.PSF,'String');
PSF                = get(handles.PSF,'UserData');

Norm               = get(handles.NormImg,'Value');
Contours           = get(handles.Contours,'Value');
ContVal            = get(handles.ContVal,'String');
RemZLP             = get(handles.RemZLP,'Value');
DispEnergy         = get(handles.DispEnergy,'String');
SubMeth            = get(handles.SubMeth,'String');
PeakNoPos          = get(handles.PeakNo,'Value');
SubMethPos         = get(handles.SubMeth,'Value');
Modus              = get(handles.DecEELS,'UserData');
AlignPanel         = get(handles.AlignPanel,'UserData');
GainVal            = get(handles.GainVal,'String');
IntDev             = get(handles.IntDev,'String');
BetaCorr           = get(handles.BetaCorr,'String');
BetaConv           = get(handles.BetaConv,'String');
ReadStd            = get(handles.ReadStd,'String');
ReadFull           = get(handles.ReadFull,'String');
CorrSat            = get(handles.CorrSat,'UserData');
StrCorrSat         = get(handles.CorrSat,'String');
text71             = get(handles.text71,'UserData');

PhiVal             = get(handles.PhiVal,'String');
ExposureTime       = get(handles.ExposureTime,'String');
VertBinning        = get(handles.VertBinning,'String');
SpecBinning        = get(handles.SpecBinning,'String');
DecMeth            = get(handles.DecMeth,'String');
DecMethPos         = get(handles.DecMeth,'Value');
Thres              = get(handles.Thres,'String');
Sigma              = get(handles.DecMeth,'UserData');
Log                = get(handles.Logbook,'UserData');
DiffMult           = get(handles.DiffMult,'String');
Width              = get(handles.Width,'String');
StartPar           = get(handles.DiffMult,'UserData');
Cut                = get(handles.EstimatePhi,'UserData');
BGArtifacts        = get(handles.BGArtifacts,'UserData');
DFandGain          = get(handles.DFandGain,'UserData');
DarkSub            = get(handles.DarkSub,'UserData');
CorrGainRef        = get(handles.CorrGainRef,'UserData');
ZLP2D              = get(handles.ZLP2D,'UserData');
FramePara          = get(handles.FramePara,'UserData');
Processing         = get(handles.Processing,'String');

%% Visibles
Vtext         = get(handles.text,'Visible');
Vtext4        = get(handles.text4,'Visible');
Vtext6        = get(handles.text6,'Visible');
Vtext7        = get(handles.text7,'Visible');
Vtext12       = get(handles.text12,'Visible');
VMinEnergy    = get(handles.MinEnergy,'Visible');
VMaxEnergy    = get(handles.MaxEnergy,'Visible');
VDispRange    = get(handles.DispRange,'Visible');
VImageFilter  = get(handles.ImageFilter,'Visible');
VSavePanel    = get(handles.SavePanel,'Visible');
VAxis         = get(handles.Axis,'Visible');
VSlider       = get(handles.Slider,'Visible');
VCAxisMax     = get(handles.CAxisMax,'Visible');
VCAxisMin     = get(handles.CAxisMin,'Visible');
VDispEnergy   = get(handles.DispEnergy,'Visible');
Vtext10       = get(handles.text10,'Visible');
VFWHM         = get(handles.ShowFWHM,'Visible');
VShowInt      = get(handles.ShowInt,'Visible');
VSpec         = get(handles.Spec,'Visible');
VSingleSpec   = get(handles.SingleSpec,'Visible');
VZLPAlign     = get(handles.ZLPAlign,'Visible');
VPeakNo       = get(handles.PeakNo,'Visible');
VDelete       = get(handles.Delete,'Visible');
VDeleteFit    = get(handles.DeleteFit,'Visible');

VShowDen      = get(handles.ShowDen,'Visible');
VShowDrift    = get(handles.ShowDrift,'Visible');
VShowOrginal  = get(handles.ShowOrginal,'Visible');
VShowDecvonv  = get(handles.ShowDeconv,'Visible');
VShowDecSub   = get(handles.ShowDecSub,'Visible');
VShowPeak     = get(handles.ShowPeak,'Visible');
VShowZLPLog   = get(handles.ShowZLPLog,'Visible'); 

VArtifacts    = get(handles.Artifacts,'Visible');
VBack         = get(handles.Background,'Visible');
VAlignPeak    = get(handles.AlignPeak,'Visible');
VDecIter      = get(handles.DecIter,'Visible');
VDecEELS      = get(handles.DecEELS,'Visible');
VDeconvSub    = get(handles.DeconvSub,'Visible');
VDecSubIter   = get(handles.DecSubIter,'Visible');
VZLPPanel     = get(handles.ZLPPanel,'Visible');
VDecFac1      = get(handles.DecFac1,'Visible');
VSubDecFac1   = get(handles.SubDecFac1,'Visible');
VDecFac2      = get(handles.DecFac2,'Visible');
VSubDecFac2   = get(handles.SubDecFac2,'Visible');
VDecMeth      = get(handles.DecMeth,'Visible');
VThres        = get(handles.Thres,'Visible');
Vtext26       = get(handles.text26,'Visible');
Vtext32       = get(handles.text32,'Visible');
VLog          = get(handles.Logbook,'Visible');
VLiveFitPanel = get(handles.LiveFitPanel,'Visible');
VNoiseBox     = get(handles.NoiseBox,'Visible');
VAlignPanel   = get(handles.AlignPanel,'Visible');
VFitPanel     = get(handles.FitPanel,'Visible');
VDispPanel    = get(handles.DispPanel,'Visible');
VIntDev       = get(handles.IntDev,'Visible');
Vtext40       = get(handles.text40,'Visible');
Vtext41       = get(handles.text41,'Visible');
Vtext43       = get(handles.text43,'Visible');
VRestImg      = get(handles.RestImg,'Visible');
VExposureTime = get(handles.ExposureTime,'Visible');
Vtext71       = get(handles.text71,'Visible');
Vtext74       = get(handles.text74,'Visible');
VDFandGain    = get(handles.DFandGain,'Visible');
VHQDark       = get(handles.HQDark,'Visible');
VCorrGainRef  = get(handles.CorrGainRef,'Visible');
VFramePara    = get(handles.FramePara,'Visible');
Vtext92       = get(handles.text92,'Visible');
VVertBinning  = get(handles.VertBinning,'Visible');
VSpecBinning  = get(handles.SpecBinning,'Visible');
VProcessing   = get(handles.Processing,'Visible');
Vtext95       = get(handles.text95,'Visible');
VCorrSat      = get(handles.CorrSat,'Visible');

WaitSave.Send;
%% Names
AlignName    = get(handles.ZLPAlign,'String');


Time      = string(datetime('now'));
Time      = strrep(Time,':','-');
Time      = strrep(Time,' ','_');
FullName  = fullfile(SavePath,strcat(FileName,'_Session_', Time,'.mat'));

save(FullName,'ShowOrg','Original','SubtrZLP','ShowDen','ShowDeconv','ShowDecSub','Add','DecAdd','DenLog','DenIntLog','DeconvLog','DecSubLog',...
    'SubtrZLPLog','ZLP1','ZLP1_old','ZLP1Energies','ZLP1FWHM','ZLP1PreZLP','ZLP1Drift','ZLP1Exp','ZLP2','ZLP2_old','ZLP2Energies','ZLP2FWHM','ZLP2PreZLP','ZLP2Drift','ZLP2Exp','ZLP1Log','ZLP2Log','AlignZLP1Log','AlignZLP2Log','ZLPs',...
    'FileName','SavePath','ShowFWHM','ShowInt','ShowDrift','Cut','ZLPAlign','Load','SliderMax','SliderMin','SliderMaxMin',...
    'SliderSteps','SliderPos','CAxisMaxMax','CAxisMaxMin','CAxisMaxSliderStep','CAxisMaxPos','CAxisMinMax','CAxisMinMin',...
    'CAxisMinSliderStep','CAxisMinPos','MaxEnergy','MinEnergy','DispRange','Zoom','Back','Spec','SingleSpec','LoadPath',...
    'IntFac1','DecFac1','SubDecFac1','IntFac2','DecFac2','SubDecFac2','IntIter','DenInt','DecSubIter','DecIter',...
    'Norm','Contours','ContVal','RemZLP','DispEnergy','SubMeth','SubMethPos','DecMeth','PeakNoPos','ZLP1Cut','ZLP2Cut','ZLP1Fine','ZLP2Fine','PSF','StrPSF',...
    'DecMethPos','Modus','AlignPanel','GainVal','IntDev','BetaCorr','BetaConv','ReadStd','ReadFull','PhiVal','ExposureTime','Thres','Sigma','Log',...
    'DiffMult','Width','StartPar','DFandGain','BGArtifacts','DarkSub','CorrGainRef','CorrGainRefString','ZLP2D','VertBinning','SpecBinning','FramePara','Processing','CorrSat','StrCorrSat','text71',...
    'Vtext','Vtext4','Vtext6','Vtext7','Vtext12','VMinEnergy','VMaxEnergy','VDispRange','VAxis','VSlider','VCAxisMax','VImageFilter',...
    'VCAxisMin','VDispEnergy','Vtext10','VFWHM','VShowInt','VShowPeak','VSpec','VSingleSpec','VZLPAlign',...
    'VSavePanel','VShowDen','VShowDrift','VShowOrginal','VShowPeak','VShowDecvonv','VShowDecSub','VShowZLPLog','VAlignPeak','VArtifacts','VBack',...
    'VDecIter','VDecEELS','VDeconvSub','VDecSubIter','VZLPPanel','VAlignPeak','VDelete','VDeleteFit',...
    'VDecFac1','VSubDecFac1','VDecFac2','VSubDecFac2','VLog','VLiveFitPanel',...
    'VIntDev','Vtext40','Vtext41','VDecMeth','VThres','Vtext26','Vtext32',...
    'Vtext43','VRestImg','VPeakNo','Log','AlignName','VNoiseBox','VAlignPanel','VFitPanel','VDispPanel','VExposureTime',...
    'Vtext71','Vtext74','VDFandGain','VHQDark','VCorrGainRef','VFramePara','Vtext92','VVertBinning','VSpecBinning','VProcessing','Vtext95','VCorrSat');
WaitSave.Send;
WaitSave.Destroy;

clearvars all
clear global
msgbox('Full session saved!')
end